package presentation;

import javax.swing.JPanel;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import java.awt.Rectangle;
import javax.swing.JComboBox;

import javax.swing.JButton;
import control.CState;
import control.Community;
import abstraction.State;
import abstraction.Service;
import java.util.Iterator;

/**
 * Dialog that  allow to choice the start states of the target and available services
 * 
 */
public class StartStatesDialog extends JDialog {

	private static final long serialVersionUID = 646838933711454544L;
	// initial states
	private Service target;
	private Community community;
	
	private State targetInitialState = null;
	private CState availableInitialStates= null;
	private CState tempAvailableInitialStates= null;
	
	private JPanel initialStatesContentPane = null;
	
	private JLabel targetInitialStateLabel = null;
	private JLabel availableInitialStatesLabel = null;
	private JLabel availableServiceLabel = null;
	
	private JComboBox targetInitialStateComboBox = null;
	private JComboBox serviceComboBox = null;
	private JComboBox initialAvailableStateComboBox = null;
	private DefaultComboBoxModel boxModel = null;
	
	private JButton okButton = null;
	private JButton cancelButton = null;

	/**
	 * @param owner
	 */
	public StartStatesDialog(Frame owner, Service targ, Community comm) {
		super(owner);
		target = targ;
		community = comm;
		tempAvailableInitialStates = community.getInitialStates();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		this.setSize(296, 353);
		this.setContentPane(getInitialStatesContentPane());
		this.setResizable(false);
		this.setModal(true);
		this.setTitle("Set Initial States");
		this.setVisible(true);
	}

	/**
	 * This method initializes initialStatesContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getInitialStatesContentPane() {
		if (initialStatesContentPane == null) {
			availableServiceLabel = new JLabel();
			availableServiceLabel.setBounds(new Rectangle(30, 105, 226, 16));
			availableServiceLabel.setText("Available Service Name:");
			availableInitialStatesLabel = new JLabel();
			availableInitialStatesLabel.setBounds(new Rectangle(30, 180, 226, 16));
			availableInitialStatesLabel.setText("Available Inital States:");
			targetInitialStateLabel = new JLabel();
			targetInitialStateLabel.setBounds(new Rectangle(30, 15, 226, 16));
			targetInitialStateLabel.setText("Target Initial State: "+target.getInitialState());
			initialStatesContentPane = new JPanel();
			initialStatesContentPane.setLayout(null);
			initialStatesContentPane.add(targetInitialStateLabel, null);
			initialStatesContentPane.add(getTargetInitialStateComboBox(), null);
			initialStatesContentPane.add(availableInitialStatesLabel, null);
			initialStatesContentPane.add(getOkButton(), null);
			initialStatesContentPane.add(getCancelButton(), null);
			initialStatesContentPane.add(availableServiceLabel, null);
			initialStatesContentPane.add(getServiceComboBox(), null);
			initialStatesContentPane.add(getInitialAvailableStateComboBox(), null);
		}
		return initialStatesContentPane;
	}

	/**
	 * This method initializes targetInitialStateComboBox	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getTargetInitialStateComboBox() {
		if (targetInitialStateComboBox == null) {
			targetInitialStateComboBox = new JComboBox();
			targetInitialStateComboBox.setBounds(new Rectangle(60, 45, 151, 31));
			targetInitialStateComboBox.setToolTipText("Choose an initial state for the target service");
			
			// add items
			Iterator<State> it = target.getStates();
			while(it.hasNext())
				targetInitialStateComboBox.addItem(it.next());
			targetInitialStateComboBox.setSelectedIndex(-1);
			
			targetInitialStateComboBox.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					targetInitialStateLabel.setText("Target Initial State: "+(State)targetInitialStateComboBox.getSelectedItem());
				}
			});
		}
		return targetInitialStateComboBox;
	}

	/**
	 * This method initializes okButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getOkButton() {
		if (okButton == null) {
			okButton = new JButton();
			okButton.setBounds(new Rectangle(30, 270, 92, 31));
			okButton.setText("Ok");
			okButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					
					targetInitialState = (State)targetInitialStateComboBox.getSelectedItem();
					if(targetInitialState == null)
						targetInitialState = target.getInitialState();
					availableInitialStates = tempAvailableInitialStates;
					
					closeDialog();
				}
			});
		}
		return okButton;
	}

	/**
	 * This method initializes cancelButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getCancelButton() {
		if (cancelButton == null) {
			cancelButton = new JButton();
			cancelButton.setBounds(new Rectangle(165, 270, 91, 31));
			cancelButton.setText("Cancel");
			cancelButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					targetInitialState = null;
					availableInitialStates = null;
					closeDialog();
				}
			});
		}
		return cancelButton;
	}
	
	/**
	 * close dialog
	 */
	private void closeDialog()
	{
		this.setVisible(false);
	}
	
	/**
	 * Getter of start state of target service
	 * @return State
	 */
	public State getTargetStartState() {
		return targetInitialState;
	}

	/**
	 * Getter of start states of available services
	 * @return CState
	 */
	public CState getAvailableStartStates() {
		return availableInitialStates;
	}

	/**
	 * This method initializes serviceComboBox	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getServiceComboBox() {
		if (serviceComboBox == null) {
			serviceComboBox = new JComboBox();
			serviceComboBox.setBounds(new Rectangle(60, 135, 151, 31));
			serviceComboBox.setToolTipText("Choose an available service");
			
			for(int i=0; i<community.size(); i++)
			{
				serviceComboBox.addItem(community.getService(i));
			}
			serviceComboBox.setSelectedIndex(-1);
			
			serviceComboBox.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					
					boxModel = new DefaultComboBoxModel();
					
					int index = serviceComboBox.getSelectedIndex();
					Service serv = community.getService(index);
					State actualState = tempAvailableInitialStates.get(index);
					
					availableServiceLabel.setText("Available Service Name: "+serv.getName());
					availableInitialStatesLabel.setText("Available Inital States: "+actualState.getName());
					
					Iterator<State> it = serv.getStates();
					while(it.hasNext())
					{
						boxModel.addElement((State)it.next());
					}
					initialAvailableStateComboBox.setModel(boxModel);
				}
			});
		}
		return serviceComboBox;
	}

	/**
	 * This method initializes initialAvailableStateComboBox	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getInitialAvailableStateComboBox() {
		if (initialAvailableStateComboBox == null) {
			initialAvailableStateComboBox = new JComboBox();
			initialAvailableStateComboBox.setBounds(new Rectangle(60, 210, 151, 31));
			initialAvailableStateComboBox.setToolTipText("Choose an initial state for the selected service");
			initialAvailableStateComboBox
					.addItemListener(new java.awt.event.ItemListener() {
						public void itemStateChanged(java.awt.event.ItemEvent e) {
							int indexServ = serviceComboBox.getSelectedIndex();
							State state = (State)initialAvailableStateComboBox.getSelectedItem();
							availableInitialStatesLabel.setText("Available Inital States: "+state.getName());
							tempAvailableInitialStates = tempAvailableInitialStates.buildNewState(indexServ, state);
						}
					});
		}
		return initialAvailableStateComboBox;
	}
}
